#include <iostream>
#include <vector>
#include <queue>

using namespace std;

int bfs(vector<vector<bool> > graph, int x, int y)
{
	queue<int> q;
	vector<bool> visited (false, graph.size());
	q.push(x);
	vector<int> path (-1, graph.size());
	while(q.size() != 0)
	{
		int i = q.front();
		visited[i] = true;
		for(int j = 0; j < graph.size(); ++j)
			if(graph[i][j] && !visited[j]) 
			{
				q.push(j);
				path[j] = i;
			}
		
	}
	int dist = 0;
	while(y != x)
	{
		++dist;
		y = path[y];
	}
}

void recur(vector<int>& arr, vector<vector<int> >& c, int l, int r)
{
	if(l == r) return;
	if(arr[l] == arr[r])
	{
		c[arr[l]][0] = l;
		c[arr[l]][1] = r;
		recur(arr, c, l+1, r-1);
		return;
	}
	recur(arr, c, l+1, r);
	recur(arr, c, l, r-1);
}

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	
	int n, q;
	cin >> n >> q;
	
	vector<int> arr (n);
	for(int i = 0; i < n; ++i)
		cin >> arr[i];
		
	vector<vector<int> > c;
	int nd = n/2;
	for(int i = 0; i < nd; ++i)
	{
		vector<int> temp (2);
		for(int j = 0; j < 2; ++j)
			temp[j] = (-1);
		c.push_back(temp);
	}
	
	recur(arr, c, 0, n-1);
	vector<vector<bool> > graph;
	for(int i = 0; i < nd; ++i)
	{
		vector<bool> temp (2);
		for(int j = 0; j < 2; ++j)
			temp[j] = false;
		graph.push_back(temp);
	}
	
	for(int i = 0; i < nd; ++i)
		for(int j = i; j < nd; ++j)
			if((c[i][0] < c[j][0] && c[i][1] > c[j][1]) || (c[i][0] > c[j][0] && c[i][1] < c[j][1])) 
			{
				graph[i][j] = true;
				graph[j][i] = true;
			}
	vector<int> sols;
	while(q > 0)
	{
		int x, y;
		cin >> x >> y;
		sols.push_back(bfs(graph, x, y));
	}
	
	for(int i = 0; i < sols.size(); ++i)
		cout << sols[i] <<endl;
}